 ; Ŀ
 ;   Flip - switch single sided wire tags for double and vice versa.       
 ;   Copyright 1997, 2001, 2002, 2008 by Rocket Software Ltd.              
 ;   Office work costs the gaming industry an estimated $6 Billion a year. 
 ; 

 ; Ŀ
 ;   Atlist - suck attribute values from a block into a list.              
 ; 
 (DEFUN ATLIST (enam / entt tagg taglst)
  (while (and (setq entt (entget (setq enam (entnext enam))))
              (/= (cdr (assoc 0 entt)) "SEQEND"))
         (setq tagg (cdr (assoc 1 entt)))
         (setq taglst (append taglst (list tagg))))
 taglst)
 ; Ŀ
 ;   Atlist end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Oclo - switch open devices for closed and vice versa.      
 ; 
 (DEFUN OCLO (enam / esav devlst num sub devls2 entt blnam gnusub pa xscl yscl
                                                                    attlst tag)
  (setq esav enam)
 ; Ŀ
 ;   Make the internal open vs. closed equivalent device list.             
 ;   The open equivalent block should come first.                          
 ;   Make the list all caps so can strcase the block name and compare.     
 ; 
  (setq devlst '(("TDSD-O" "TDSD-C")   ("TDSE-O" "TDSE-C")
                 ("PUSH-NO" "PUSH-NC") ("CONTACT-NO" "CONTACT-NC")
                 ("LSL" "LSH")         ("ZSO" "ZSC")
                 ("FSL" "FSH")         ("PSL" "PSH")
                 ("DPSL" "DPSH")       ("VSL" "VSH")
                 ("TSL" "TSH")         ("SWITCH-NO" "SWITCH-NC")
                 ("LSL" "LSH")         ("MUSHROOM-NO" "MUSHROOM-NC")))
 ; Ŀ
 ;   Make the second list with the closed blocks first.                    
 ; 
  (setq num 0)
  (while (setq sub (nth num devlst))
         (setq devls2 (cons (reverse sub) devls2))
         (setq num (1+ num)))
 ; Ŀ
 ;   Make the two lists into one.                                          
 ; 
  (setq devlst (append devlst devls2))
 ; Ŀ
 ;   See if the selected device is part of the list.                       
 ; 
  (if (and (setq entt (entget enam))
           (setq blnam (strcase (cdr (assoc 2 entt))))
           (setq gnusub (assoc blnam devlst)))
      (progn
 ; Ŀ
 ;   Get block insertion point and scales and the attribute value list.    
 ; 
           (setq pa (cdr (assoc 10 entt)))
           (setq xscl (cdr (assoc 41 entt)))
           (setq yscl (cdr (assoc 42 entt)))
           (setq attlst (atlist esav))
 ; Ŀ
 ;   Swap out the old block for the new one.                               
 ; 
           (entdel enam)
           (command ".insert" (cadr gnusub) pa xscl yscl "0")
           (while (setq tag (car attlst))
                  (setq attlst (cdr attlst))
                  (command tag))
           (while (= 1 (getvar "cmdactive")) (command " "))))
 (princ))
 ; Ŀ
 ;   Oclo end.                                                             
 ; 

 ; Ŀ
 ;   Flip.                                                                 
 ; 
 (DEFUN C:FLIP (/ attd blip snapp clayer *error* enam entt blnam pa xscl yscl
                                                   attval passr ssr passl ssl)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq attd (getvar "attdia"))
  (setvar "attdia" 0)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq snapp (getvar "snapmode"))
  (setq clayer (getvar "clayer"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Locally redefine the error handler.                                   
 ; 
  (DEFUN *error* (shk /)
   (setvar "attdia" attd)
   (setvar "blipmode" blip)
   (setvar "snapmode" snapp)
   (setvar "clayer" clayer)
   (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Logic for three state blocks (left, right, and both): if there is a   
 ;   line crossing the insertion of a block but not the point where the    
 ;   opposite block would be inserted, cycle between that single sided     
 ;   block and the two sided one.  If only the opposite line is present    
 ;   go to the two sided block.  If both or neither is present then cycle  
 ;   left to both to right to left.                                        
 ; 
  (if (and (setq enam (entsel "Tag: "))
           (setq entt (entget (setq enam (car enam))))
           (setvar "clayer" (cdr (assoc 8 entt)))
           (setq blnam (strcase (cdr (assoc 2 entt))))
           (member blnam (list "WIRTAGHL" "WIRTAGHR" "1WIRETAG" "2WIRETAG"
                               "2XWIRETAG" "HWIRETAG" "HWIRETAGR"
                               "VWIRETAG" "VWIRETAGR")))
      (progn
 ; Ŀ
 ;   Get block insertion point, scales, and the attribute value.           
 ; 
           (setq pa (cdr (assoc 10 entt)))
           (setq xscl (cdr (assoc 41 entt)))
           (setq yscl (cdr (assoc 42 entt)))
           (setq attval (cdr (assoc 1 (entget (entnext enam)))))
 ; Ŀ
 ;   Decide which tag we are dealing with, replace it.                     
 ;   1. The tags for vertical wires.                                       
 ; 
           (cond ((= blnam "VWIRETAG")
                  (command "insert" "VWIRETAGR" pa yscl "" "0" attval))
                 ((= blnam "VWIRETAGR")
                  (command "insert" "VWIRETAG" pa yscl "" "0" attval))
 ; Ŀ
 ;   2. The block with the tag (& thus the wire) to the left of the text.  
 ; 
                 ((member blnam '("HWIRETAG""WIRTAGHL" "1WIRETAG"))
                  (setq pa (polar pa 0 (* xscl 7.5)))
                  (command "insert" "2XWIRETAG" pa yscl "" "0" attval))
 ; Ŀ
 ;   3. The block with a tag on each side of the text.                     
 ; 
                 ((member blnam '("2XWIRETAG" "2WIRETAG"))
 ; Ŀ
 ;   Find which side of the block is on a line.                            
 ; 
                  (setq passr (polar pa 0 (* yscl 7)))
                  (setq ssr (ssget "C" (polar passr (/ pi 2) yscl)
                                       (polar passr (* pi 1.5) yscl)))
                  (setq passl (polar pa pi (* yscl 7)))
                  (setq ssl (ssget "C" (polar passl (/ pi 2) yscl)
                                       (polar passl (* pi 1.5) yscl)))
 ; Ŀ
 ;   The logic here is a bit convoluted: want to go R to 2X to L,          
 ;   but if going from 2X then go preferentially to where there is a       
 ;   line, and if both or no line then go to R.                            
 ;   So if there are lines on both sides or neither or just the right,     
 ;   put the right tag in, else the left, so if there is only a line on    
 ;   the left then put in the left tag, otherwise install a right one.     
 ; 
                  (if (and ssl (null ssr))
                      (command "insert" "HWIRETAG" (polar pa pi (* yscl 7.5))
                                        yscl "" "0" attval)
                      (command "insert" "HWIRETAGR" (polar pa 0 (* yscl 7.5))
                                        yscl "" "0" attval)))
 ; Ŀ
 ;   4. The block with the tag (& thus the wire) to the right of the text. 
 ; 
                 ((member blnam '("HWIRETAGR" "WIRTAGHR"))
 ; Ŀ
 ;   Find which side of the block is on a line.                            
 ; 
                  (setq passr (polar pa pi (* yscl 0.5)))
                  (setq ssr (ssget "C" (polar passr (/ pi 2) yscl)
                                       (polar passr (* pi 1.5) yscl)))
                  (setq passl (polar pa pi (* yscl 14.5)))
                  (setq ssl (ssget "C" (polar passl (/ pi 2) yscl)
                                       (polar passl (* pi 1.5) yscl)))
 ; Ŀ
 ;   Logic: if there is only one wire and it crosses the insert of this    
 ;   tag then go to the two sided tag, otherwise the left side tag is a    
 ;   viable option so go to that.                                          
 ; 
                  (if (and ssr (null ssl))
                      (command "insert" "2XWIRETAG" (polar pa pi (* xscl 7.5))
                                         yscl "" "0" attval)
                      (command "insert" "HWIRETAG" (polar pa pi (* xscl 15))
                                         yscl "" "0" attval))))
           (entdel enam)
           (redraw (entlast)))
 ; Ŀ
 ;   If on the other hand the block wasn't one of the ones in the list     
 ;   then call Oclo to see if it was a switch.                             
 ; 
      (oclo enam))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "attdia" attd)
  (setvar "blipmode" blip)
  (setvar "snapmode" snapp)
  (setvar "clayer" clayer)
  (command "undo" "end")
 (princ))